<?php

namespace Infrastructure\Services\Utilities\Projects\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class PickedFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('picked', $value);
    }

    public static function key(): string
    {
        return 'is_picked';
    }
}