<?php

namespace Infrastructure\Services\Utilities\Projects\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class NameFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where(function ($query) use ($value) {
            $query->where('name_en', 'like', '%' . $value . '%')
                ->orWhere('name_ar', 'like', '%' . $value . '%')
                ->orWhereHas('user.details', function ($query) use ($value) {
                    $query->where('business_name_en', 'like', '%' . $value . '%')
                        ->orWhere('business_name_ar', 'like', '%' . $value . '%');
                });
        });
    }

    public static function key(): string
    {
        return 'name';
    }
}
