<?php

namespace Infrastructure\Services\Utilities\Projects\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class CategoryIdFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('category_id', '=', $value);
    }

    public static function key(): string
    {
        return 'category_id';
    }
}
