<?php

namespace Infrastructure\Services\Utilities\GeneralFilters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class StatusFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('status', '=', $value);
    }

    public static function key(): string
    {
        return 'status';
    }
}
