<?php

namespace Infrastructure\Services\Utilities\GeneralFilters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class HomeStatusFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('home_status', '=', $value);
    }

    public static function key(): string
    {
        return 'home_status';
    }
}
