<?php

namespace Infrastructure\Services\Utilities\Cities\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class StateIdFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        if (is_string($value) && str_contains($value, ',')) {
            $ids = array_map('trim', explode(',', $value));
            $builder->whereIn('state_id', $ids);
        } else {
            $builder->where('state_id', '=', $value);
        }
    }

    public static function key(): string
    {
        return 'state_id';
    }
}